/*! \file
**********************************************************************************
*Title:                         Discretix Certificate Handling Toolkit source file
*
* Filename:                     tlk_cert_types.h 
*
* Project, Target, subsystem:   Certificate Handling Toolkit, OMA DRM
*
* Created:                      28.01.2008
*
* Modified:                     28.01.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_CERT_API_TYPES_H_
#define _TLK_CERT_API_TYPES_H_
#ifdef __cplusplus
extern "C" {
#endif

#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_TimeUtils.h"

#include "CRYS_HASH.h"

#include "tlk_cert_defs.h"

/*!
\brief  This structure describes general buffer structure.
**/typedef struct _TLK_CERT_Buffer_t
{
    DxUint32_t                  buffSizeInBytes;              /*!<buffSizeInBytes                      - A length of the general buffer                                            **/
    DxByte_t                   *buff_ptr;                     /*!<buff_ptr                             - A pointer to the general buffer                                           **/
}TLK_CERT_Buffer_t;

/*!
\brief  This structure describes general buffer structure.
**/typedef struct _TLK_CERT_BufferOffest_t
{
    DxUint32_t                  buffSizeInBytes;              /*!<buffSizeInBytes                      - A length of the general buffer                                            **/
    DxUint32_t                  offsetInBytes;                /*!<buff_ptr                             - Offset of the specific field from the certificate base                    **/
}TLK_CERT_BufferOffest_t;

typedef enum
{
    TLK_CERT_DIGITAL_SIGNATURE = 0,
    TLK_CERT_NON_REPUDIATION   = 1,
    TLK_CERT_KEY_ENCIPHERMENT  = 2, 
    TLK_CERT_DATA_ENCIPHERMENT = 3,
    TLK_CERT_KEY_AGREEMENT     = 4,
    TLK_CERT_KEY_CERTSIGN      = 5,
    TLK_CERT_CRL_SIGN          = 6,
    TLK_CERT_ENCIPHER_ONLY     = 7,
    TLK_CERT_DECIPHER_ONLY     = 8,
    TLK_CERT_UNKNOWN           = 0xFF,

    TLK_CERT_KEY_USAGES_LAST   = 0x7FFFFFFF
}TLK_CERT_KeyUsages_t;

typedef struct _TLK_CERT_RsaKey_t
{
    TLK_CERT_BufferOffest_t     modulus;
    TLK_CERT_BufferOffest_t     exponent;
} TLK_CERT_RsaKey_t;

typedef DxChar_t            DxSha1Base64Result_t[TLK_CERT_HASH_SHA1_RESULT_BASE64_SIZE];

typedef DxUint8_t           DxSha1Result_t[TLK_CERT_HASH_SHA1_RESULT_SIZE_IN_BYTES];

typedef DxByte_t            TLK_CERT_NonceBuff_t[TLK_CERT_NONCE_SIZE_IN_BYTES];

typedef DxUint8_t           TLK_CERT_SerialNumber_t[TLK_CERT_SERIAL_NUMBER_MAX_LENGTH_IN_BYTES];

typedef DxUint32_t          TLK_CERT_MacBuffer_t[TLK_CERT_MAC_LENGTH_IN_BYTES];

typedef DxUint8_t          TLK_CERT_MacPartBuffer_t[TLK_CERT_NONCE_MAC_PART_SIZE_IN_BYTES];

typedef struct _TLK_CERT_AlgorithmIdentifier_t
{
    TLK_CERT_BufferOffest_t               algorithm;
    /* Optional */
    TLK_CERT_BufferOffest_t               parameters;
}TLK_CERT_AlgorithmIdentifier_t;


typedef struct _TLK_CERT_SubjectPublicKeyInfo_t
{
    DxUint32_t                      buffSizeInBytes;              /*!<buffSizeInBytes                      - A length of the general buffer                                            **/
    DxUint32_t                      offsetInBytes;                /*!<buff_ptr                             - Offset of the specific field from the certificate base                    **/
    TLK_CERT_BufferOffest_t         subjectPublicKeyBuff;
    TLK_CERT_AlgorithmIdentifier_t  algoritmIdentifier;
}TLK_CERT_SubjectPublicKeyInfo_t;




typedef struct _TLK_CERT_tlbCertificate_t
{
    TLK_CERT_BufferOffest_t         version;
    TLK_CERT_SerialNumber_t         serialNumber;
    TLK_CERT_BufferOffest_t         signature;
    TLK_CERT_BufferOffest_t         issuerName;
    DxGeneralizedTime_t             validNotBefore;
    DxGeneralizedTime_t             validNotAfter;
    TLK_CERT_BufferOffest_t         subjectName;
    TLK_CERT_RsaKey_t               subjectPublicKey;
    TLK_CERT_Buffer_t/*TLK_CERT_KeyUsages_t*/ keyUsage;

}TLK_CERT_tlbCertificate_t;



typedef struct  _TLK_CERT_CVPO_Part_t
{
    TLK_CERT_BufferOffest_t          subjectNameEE;
    TLK_CERT_BufferOffest_t          signatureTR;
    TLK_CERT_BufferOffest_t          subjectKeyIdentifierEE;
    TLK_CERT_BufferOffest_t          subjectPublicKeyInfoEE;
    DxGeneralizedTime_t              validNotBeforeEE;
    DxGeneralizedTime_t              validNotAfterEE;
    TLK_CERT_BufferOffest_t          keyUsageEE;
    TLK_CERT_BufferOffest_t          extKeyUsageEE;
    TLK_CERT_BufferOffest_t          subjectNameTR;
    TLK_CERT_BufferOffest_t          subjectKeyIdentifierTR;
    TLK_CERT_BufferOffest_t          subjectPublicKeyInfoTR;
    DxBool_t                         trustedRootFromSecuredEnv;
    DxBool_t                         reserved1;
    DxBool_t                         reserved2;
    DxBool_t                         reserved3;
}TLK_CERT_CVPO_Part_t;


typedef struct _TLK_CERT_ContextObj_t
{
    DxUint32_t                       certificateBaseAddress;
    TLK_CERT_BufferOffest_t          signedData;
    TLK_CERT_BufferOffest_t          subjectName;
    TLK_CERT_BufferOffest_t          issuerName;
    TLK_CERT_BufferOffest_t          signature;
    TLK_CERT_BufferOffest_t          extKeyUsage;
    TLK_CERT_RsaKey_t                subjectPublicKey;
    TLK_CERT_BufferOffest_t          authorityKeyIdentifier;
    TLK_CERT_KeyUsages_t             keyUsageUserDefined;
    TLK_CERT_CVPO_Part_t             cvpoPart;
    DxUint8_t                        tbcShaDigestEncrypt[TLK_CERT_EM_STRING_SIZE_IN_BYTES];
    DxByte_t                         intenalUse[TLK_CERT_INTERNAL_USE_SIZE_IN_BYTES];
    DxBool_t                         isCa;
    DxBool_t                         trustedRootFromSecuredEnv;
    DxBool_t                         reserved1;
    DxBool_t                         reserved2;
    TLK_CERT_MacBuffer_t             mac;
}TLK_CERT_ContextObj_t;

typedef struct _TLK_CERT_CPVO_t
{
    TLK_CERT_CVPO_Part_t            cvpoPart;
    TLK_CERT_MacBuffer_t            mac;
}TLK_CERT_CPVO_t;

typedef struct _TLK_CERT_PublicKeyInfo
{
    TLK_CERT_BufferOffest_t         subjectPublicKeyInfoDER;
    TLK_CERT_RsaKey_t               subjectPublicKeyInfoValues;
}TLK_CERT_PublicKeyInfo_t;

typedef struct _TLK_CERT_CertParameters_t
{
    TLK_CERT_BufferOffest_t         serialNumber;
    TLK_CERT_BufferOffest_t         subjectName;
    TLK_CERT_BufferOffest_t         issuerName;
    DxGeneralizedTime_t             validNotBefore;
    DxGeneralizedTime_t             validNotAfter;
    TLK_CERT_PublicKeyInfo_t        subjectPublicKeyInfo;
    TLK_CERT_BufferOffest_t         keyUsage;
}TLK_CERT_CertParameters_t;

typedef struct _TLK_CERT_Nonce_t
{
    TLK_CERT_NonceBuff_t            nonce;
    DxTime_t                        timestamp;
    TLK_CERT_MacPartBuffer_t        mac;
}TLK_CERT_Nonce_t;

typedef struct _TLK_CERT_RV0_t
{
    DxSha1Result_t                  certIdentity;           /*!<certIdentity        - the id of the certificate to be checked                 **/
    DxUint32_t                      responseStatus;         /*!<responseStatus      - status of the verified response                         **/
    DxGeneralizedTime_t             objectGeneratedTime;    /*!<objectGeneratedTime - the time when this object was generated                 **/
    DxGeneralizedTime_t             producedAt;             /*!<producedAt          - the time is the time at which this response was signed  **/
    DxUint32_t                      certStatus;             /*!<certStatus          - the status of certificate to be checked                 **/
    TLK_CERT_MacBuffer_t            mac;                    /*!<mac                 - HMAC of the current object fields                       **/
}TLK_CERT_RV0_t;
#ifdef __cplusplus
}
#endif
#endif
